mount_vfs_model_path(LockOn_Options.script_path.."../Shape")

mount_vfs_texture_archives("Bazar/Textures/AvionicsCommon")

dofile(LockOn_Options.script_path		.."config.lua")
dofile(LockOn_Options.script_path		.."devices.lua")
dofile(LockOn_Options.common_script_path.."tools.lua")
dofile(LockOn_Options.script_path		.."materials.lua")

MainPanel = {"F5E::ccF5MainPanel", 
			LockOn_Options.script_path.."mainpanel_init.lua",
			{{"FM_Proxy",			devices.FM_PROXY},
			 {"control_interface",	devices.CONTROL_INTERFACE},
			 {"electric_interface",	devices.ELEC_INTERFACE},
			 {"fuel_interface",		devices.FUEL_INTERFACE},
			 {"hydro_interface",	devices.HYDRO_INTERFACE},
			 {"engine_interface",	devices.ENGINE_INTERFACE},
			 {"gear_interface",		devices.GEAR_INTERFACE},
			 {"oxygen_interface",	devices.OXYGEN_INTERFACE},
			 {"ecs_interface",		devices.ECS_INTERFACE},
			 {"cpt_mechanics",		devices.CPT_MECH},
			 {"extlights_system",	devices.EXTLIGHTS_SYSTEM},
			 {"intlights_system",	devices.INTLIGHTS_SYSTEM},
			 {"CMDS",				devices.CMDS},
			 {"AN_APQ159",			devices.AN_APQ159},
			 {"AN_ASG31",			devices.AN_ASG31},
			 {"RWR_IC",				devices.RWR_IC},
			 {"SightCamera",		devices.SIGHT_CAMERA},
			 -- Radio --------------------------------
			 {"IFF",				devices.IFF},
			 {"UHFRadio",			devices.UHF_RADIO},
			 {"TACAN",				devices.TACAN},
			 -- Instruments --------------------------
 			 {"AoAIndicator",		devices.AOA_INDICATOR},
 			 {"accelerometer",		devices.ACCELEROMETER},
			 {"iasMachIndicator",	devices.IAS_MACH_INDICATOR},
			 {"variometer",			devices.VARIOMETER},
			 {"AAU34",				devices.AAU34},
			 {"AI_ARU20",			devices.AI_ARU20},
			 {"HSI",				devices.HSI},
			 {"SAI",				devices.SAI},
			 {"Clock",				devices.CLOCK},
			 {"TACAN_CONTROL",		devices.TACAN_CTRL_PANEL},
			},
}

creators   = {}
-- Indicators
indicators = {}

function add_devs(tab_of_devs_and_indicators)
    local devs = tab_of_devs_and_indicators[1]
    for i,o in pairs(devs) do
        creators[i]  = o
    end
end

function add_inds(tab_of_devs_and_indicators)
    local inds = tab_of_devs_and_indicators[2]
    
    for i=1,#inds do
        indicators[#indicators + 1] = inds[i]
    end
end

creators[devices.FM_PROXY] = {
	"F5E::avFMProxy_F5",
	"",
	{}
}

creators[devices.HELMET_DEVICE]    = {"avNightVisionGoggles"}  --BKS NVG MOD

creators[devices.CONTROL_INTERFACE] = {
	"F5E::avControlInterface_F5",
	LockOn_Options.script_path.."Systems/ControlSystem.lua",
	{{"FM_proxy", devices.FM_PROXY},
	{"ElecInterface",devices.ELEC_INTERFACE}},
}

creators[devices.ELEC_INTERFACE] = {
	"F5E::avElectricInterface_F5",
	LockOn_Options.script_path.."Systems/ElectricSystem.lua",
	{{"FM_proxy", devices.FM_PROXY},
	 {"fuel_interface", devices.FUEL_INTERFACE},
	 {"oxygen_interface", devices.OXYGEN_INTERFACE}}
}

creators[devices.FUEL_INTERFACE] = { 
	"F5E::avFuelInterface_F5",
	LockOn_Options.script_path.."Systems/FuelSystem.lua",
	{{"FM_proxy", devices.FM_PROXY},
	{"ElecInterface",devices.ELEC_INTERFACE}},
}	

creators[devices.HYDRO_INTERFACE] = {
	"F5E::avHydroInterface_F5",
	LockOn_Options.script_path.."Systems/HydroSystem.lua",
	{{"FM_proxy", devices.FM_PROXY},
	{"ElecInterface",devices.ELEC_INTERFACE}},
}

creators[devices.ENGINE_INTERFACE] = { 
	"F5E::avEngineInterface_F5",
	LockOn_Options.script_path.."Systems/PowerPlant.lua",
	{{"FM_proxy", devices.FM_PROXY},
	{"ElecInterface",devices.ELEC_INTERFACE}}
}	

creators[devices.GEAR_INTERFACE] = {
	"F5E::avGearInterface_F5",
	LockOn_Options.script_path.."Systems/GearSystem.lua",
	{{"ElecInterface", devices.ELEC_INTERFACE},
	{"IntercomInterface", devices.INTERCOM}}
}

creators[devices.OXYGEN_INTERFACE]	= {
	"F5E::avOxygenInterface_F5",
	LockOn_Options.script_path.."Systems/OxygenSystem.lua",
	{{"FM_proxy", devices.FM_PROXY},
	{"ElecInterface",devices.ELEC_INTERFACE}}
}

creators[devices.ECS_INTERFACE]	= {
	"F5E::avECSInterface_F5",
	LockOn_Options.script_path.."Systems/ECSystem.lua",
	{{"FM_proxy", devices.FM_PROXY}}
}

creators[devices.CPT_MECH] = { 
	"F5E::avCockpitMechanics_F5",
	LockOn_Options.script_path.."Systems/CockpitMechanics.lua",
	{{"ElecInterface", devices.ELEC_INTERFACE}}
}

creators[devices.EXTLIGHTS_SYSTEM] = {
	"F5E::avExtLightsSystem_F5",
	LockOn_Options.script_path.."Systems/ExtLights.lua",
	{{"ElecInterface",devices.ELEC_INTERFACE}}
}

creators[devices.INTLIGHTS_SYSTEM] = {
	"F5E::avIntLightsSystem_F5",
	LockOn_Options.script_path.."Systems/IntLights.lua",
	{{"ElecInterface",devices.ELEC_INTERFACE}}
}

creators[devices.CMDS] = {
	"F5E::avAN_ALE40V_F5",
	LockOn_Options.script_path.."Systems/AN_ALE40V.lua",
	{{"ElecInterface",devices.ELEC_INTERFACE},
	 {"WeapControl", devices.WEAPONS_CONTROL}}
}

creators[devices.JETTISON_SYSTEM] = {
	"F5E::avJettisonSystem_F5",
	LockOn_Options.script_path.."Systems/JettisonSystem.lua",
	{{"ElecInterface",devices.ELEC_INTERFACE}}
}

creators[devices.WEAPONS_CONTROL] = {
	"F5E::avWeaponsControl_F5",
	LockOn_Options.script_path.."Systems/WeaponsControl.lua",
	{{"ElecInterface",	devices.ELEC_INTERFACE},
	 {"JettisonSystem",	devices.JETTISON_SYSTEM},
	 {"AN_ASG31", devices.AN_ASG31}}
}

creators[devices.AHRS] = {
	"F5E::avAHRS_F5",
	LockOn_Options.script_path.."Systems/AHRS.lua",
	{{"ElecInterface",	devices.ELEC_INTERFACE},
	 {"TACAN",			devices.TACAN},
	 {"UHF_RADIO",		devices.UHF_RADIO},
	 {"HSI",			devices.HSI}}
}

creators[devices.AN_APQ159] = {
	"F5E::avAN_APQ159_F5",
	LockOn_Options.script_path.."AN_APQ159/device/AN_APQ159.lua",
	{{"ElecInterface", devices.ELEC_INTERFACE},
	 {"AN_ASG31", devices.AN_ASG31},
	 {"LightInterface", devices.INTLIGHTS_SYSTEM},
	 {"AHRS", devices.AHRS}},
}

creators[devices.AN_ASG31]	= {
	"F5E::avAN_ASG31_F5",
	LockOn_Options.script_path.."AN_ASG31/device/AN_ASG31.lua",
	{{"ElecInterface", devices.ELEC_INTERFACE},
	 {"AN_APQ159", devices.AN_APQ159},
	 {"weapon_controls", devices.WEAPONS_CONTROL},
	 {"FM_proxy", devices.FM_PROXY},
	 {"AHRS", devices.AHRS}},
}

creators[devices.RWR_IC] = {
	"F5E::avRWR_IC_F5",
	LockOn_Options.script_path.."AN_ALR87/device/RWR_IC.lua",
	{{"ElecInterface",devices.ELEC_INTERFACE},
	 {"AN_ALR87", devices.AN_ALR87}},
}

creators[devices.AN_ALR87] = {
	"F5E::avAN_ALR87_F5",
	LockOn_Options.script_path.."AN_ALR87/device/AN_ALR87.lua",
	{{"ElecInterface",devices.ELEC_INTERFACE},
	 {"RWR_IC", devices.RWR_IC}},
}

creators[devices.SIGHT_CAMERA] = {
	"F5E::avSightCamera_F5",
	LockOn_Options.script_path.."SightCamera/dev.lua",
	{{"ElecInterface", devices.ELEC_INTERFACE}},
}

-- Radio --------------------------------
creators[devices.IFF]	= {
	"F5E::avIFF_APX72_F5",
	"",
	{{"ElecInterface",devices.ELEC_INTERFACE}}
}

creators[devices.UHF_RADIO]	= {
	"F5E::avAN_ARC_164_F5",
	LockOn_Options.script_path.."Radio/UHF_Radio.lua",
	{{"ElecInterface", devices.ELEC_INTERFACE}}
}

creators[devices.INTERCOM] = {
	"F5E::avIntercom_F5", 
	LockOn_Options.script_path.."Radio/Intercom.lua",
	{{"ElecInterface", devices.ELEC_INTERFACE},
	{"UHFRadio", devices.UHF_RADIO},
	{"TACAN", devices.TACAN}}
}

creators[devices.TACAN] = {
	"F5E::avTACAN_AN_ARN118_F5", 
	LockOn_Options.script_path.."Radio/TACAN.lua", 
	{{"ElecInterface", devices.ELEC_INTERFACE}},
}

creators[devices.TACAN_CTRL_PANEL] = {
	"avTACAN_ARN118_CtrlPanel", 
	LockOn_Options.script_path.."Radio/TACAN_CtrlPanel.lua", 
	{{"TACAN_ARN118", devices.TACAN}},
}

-- Instruments --------------------------
creators[devices.AOA_INDICATOR] = {
	"F5E::avAoAIndicator_F5",
	LockOn_Options.script_path.."Instruments/AoAIndicator.lua",
	{{"FM_Proxy", devices.FM_PROXY},
	 {"ElecInterface",devices.ELEC_INTERFACE}}
}

creators[devices.ACCELEROMETER] = {
	"F5E::avAccelerometer_F5",
	LockOn_Options.script_path.."Instruments/Accelerometer.lua",
	{{"FM_Proxy", devices.FM_PROXY}}
}

creators[devices.IAS_MACH_INDICATOR] = {
	"F5E::avAirspeedMachIndicator_F5",
	LockOn_Options.script_path.."Instruments/AirspeedMachIndicator.lua",
	{{"FM_Proxy", devices.FM_PROXY}}
}

creators[devices.VARIOMETER] = {
	"F5E::avVariometer_F5",
	LockOn_Options.script_path.."Instruments/Variometer.lua",
	{{"FM_Proxy", devices.FM_PROXY}}
}

creators[devices.AOA_INDEXER] = {
	"F5E::avAoAIndexer_F5",
	LockOn_Options.script_path.."Instruments/AoAIndexer.lua",
	{{"AoAIndicator", devices.AOA_INDICATOR},
	 {"ElecInterface",devices.ELEC_INTERFACE}}
}

creators[devices.AAU34] = {
	"F5E::avAAU34_F5",
	LockOn_Options.script_path.."Instruments/AAU34.lua",
	{{"FM_Proxy", devices.FM_PROXY},
	 {"ElecInterface",devices.ELEC_INTERFACE}}
}

creators[devices.AI_ARU20] = {
	"F5E::avAI_ARU20_F5",
	LockOn_Options.script_path.."Instruments/AI_ARU20.lua",
	{{"ElecInterface",devices.ELEC_INTERFACE},
	{"AHRS", devices.AHRS}}
}

creators[devices.HSI] = {
	"F5E::avHSI_F5",
	LockOn_Options.script_path.."Instruments/HSI.lua",
	{{"ElecInterface",devices.ELEC_INTERFACE},
	 {"AHRS", devices.AHRS}}
}

creators[devices.SAI] = {
	"F5E::avSAI_F5",
	LockOn_Options.script_path.."Instruments/SAI.lua",
	{{"FM_Proxy", devices.FM_PROXY},
	 {"ElecInterface",devices.ELEC_INTERFACE}}
}

creators[devices.CLOCK] = {
	"F5E::avABU11Clock_F5",
	LockOn_Options.script_path.."Instruments/Clock.lua",
	{},
}

creators[devices.STANDBY_COMPASS] = {
	"avMechCompass",
	LockOn_Options.script_path.."Instruments/StandbyCompass.lua",
	{}
}

--
creators[devices.MACROS]	= {"F5E::avAutostartDevice_F5",
								LockOn_Options.common_script_path.."Macro_handler.lua",
								{{"EngineInterface", devices.ENGINE_INTERFACE},
								{"ControlInterface", devices.CONTROL_INTERFACE}}
}

creators[devices.AIHelper]	= {"F5E::avAIHelper_F5",
								LockOn_Options.script_path.."AIHelper/AIHelperDev.lua",
								{{"ELECTRIC", devices.ELEC_INTERFACE},
								{"ENGINES", devices.ENGINE_INTERFACE},
								{"OXYGEN", devices.OXYGEN_INTERFACE},
								{"FMPROXY", devices.FM_PROXY},
								{"GEAR", devices.GEAR_INTERFACE}}
}

if LockOn_Options.flight.easy_radar then                                            						   
creators[devices.ARCADE] =          {"F5E::avArcadeRadar_F5",
									LockOn_Options.script_path.."ARCADE/arcade.lua",
									{{"padlock", devices.PADLOCK},
									 {"weapon_system", devices.WEAPONS_CONTROL},
									 {"ASG31", devices.AN_ASG31}},
									}							   
end

indicators = {}

indicators[#indicators + 1] = {
	"F5E::ccControlsIndicator_F5",
	LockOn_Options.script_path.."ControlsIndicator/ControlsIndicator.lua",
	devices.CONTROL_INTERFACE
}

indicators[#indicators + 1] = {
	"F5E::ccAN_ASG31_F5",  
	LockOn_Options.script_path.."AN_ASG31/Indicator/AN_ASG31_init.lua",
	devices.AN_ASG31,
--[[	{{"PTR-HUD-CENTER","PTR-HUD-DOWN","PTR-HUD-RIGHT"},
	{sw = 0.5}}--]]
}

indicators[#indicators + 1] = {
	"F5E::ccAN_ALR87_F5",
 	LockOn_Options.script_path.."AN_ALR87/indicator/AN_ALR87_init.lua",
	devices.AN_ALR87,
	{
	{"PTR-RWR-CENTER","PTR-RWR-DOWN","PTR-RWR-RIGHT"},
	{sx_l = 0.0005, sy_l = -0.0008, sz_l = -0.0002}
	}
}

indicators[#indicators + 1] = {
	"F5E::ccAN_APQ159_F5",
 	LockOn_Options.script_path.."AN_APQ159/indicator/AN_APQ159_init.lua",
	nil,
	{{"PTR-RADAR-CENTER","PTR-RADAR-DOWN", "PTR-RADAR-RIGHT"},
	{sx_l = -0.0015, sy_l = -0.0002, sz_l = -0.00003, rz = 0.0, sw = -0.0163, sh = -0.0165}
	}
}

indicators[#indicators + 1] = {
	"F5E::ccAN_ARC164_F5",
	LockOn_Options.script_path.."AN_ARC164/AN_ARC164_init.lua",
	devices.UHF_RADIO,
	{
		{"PTR-ANARC164-CHANNEL-MAP-SHEET-CENTER", "PTR-ANARC164-CHANNEL-MAP-SHEET-DOWN", "PTR-ANARC164-CHANNEL-MAP-SHEET-RIGHT"},
		{sx = 0.0, sy = 0.0004, sz = 0.0004}
	}
}

indicators[#indicators + 1] = {
	"F5E::ccSightCamera_F5",
	LockOn_Options.script_path.."SightCamera/init.lua",
	devices.SIGHT_CAMERA,
	{{}}
}

indicators[#indicators + 1] = {"ccAIHelperBase",	LockOn_Options.script_path.."AIHelper/AIHelper.lua",	devices.AIHelper}

if LockOn_Options.flight.easy_radar then                                            
	indicators[#indicators + 1] = {"ccArcadeRadar", LockOn_Options.script_path.."ARCADE/arcade_indicator.lua", devices.ARCADE}
end

kneeboard_implementation 		= "F5E::ccKneeboardExtension_F5"
disable_kneeboard_render_target = false
---------------------------------------------
dofile(LockOn_Options.common_script_path.."KNEEBOARD/declare_kneeboard_device.lua")
---------------------------------------------
dofile(LockOn_Options.common_script_path.."PADLOCK/PADLOCK_declare.lua")
---------------------------------------------		   
